/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.formatter.qual;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.dataflow.qual.Pure;

public enum ConversionCategory {
    GENERAL(null, "bBhHsS"),
    CHAR(new Class[]{Character.class, Byte.class, Short.class, Integer.class}, "cC"),
    INT(new Class[]{Byte.class, Short.class, Integer.class, Long.class, BigInteger.class}, "doxX"),
    FLOAT(new Class[]{Float.class, Double.class, BigDecimal.class}, "eEfgGaA"),
    TIME(new Class[]{Long.class, Calendar.class, Date.class}, "tT"),
    CHAR_AND_INT(new Class[]{Byte.class, Short.class, Integer.class}, null),
    INT_AND_TIME(new Class[]{Long.class}, null),
    NULL(new Class[0], null),
    UNUSED(null, null);

    public final Class<?>[] types;
    public final String chars;

    private ConversionCategory(Class<?>[] types, String chars) {
        this.types = types;
        this.chars = chars;
    }

    public static ConversionCategory fromConversionChar(char c11) {
        for (ConversionCategory v11 : new ConversionCategory[]{GENERAL, CHAR, INT, FLOAT, TIME}) {
            if (!v11.chars.contains(String.valueOf(c11))) continue;
            return v11;
        }
        throw new IllegalArgumentException("Bad conversion character " + c11);
    }

    private static <E> Set<E> arrayToSet(E[] a11) {
        return new HashSet<E>(Arrays.asList(a11));
    }

    public static boolean isSubsetOf(ConversionCategory a11, ConversionCategory b11) {
        return ConversionCategory.intersect(a11, b11) == a11;
    }

    public static ConversionCategory intersect(ConversionCategory a11, ConversionCategory b11) {
        if (a11 == UNUSED) {
            return b11;
        }
        if (b11 == UNUSED) {
            return a11;
        }
        if (a11 == GENERAL) {
            return b11;
        }
        if (b11 == GENERAL) {
            return a11;
        }
        Set<Class<Class<?>>> as2 = ConversionCategory.arrayToSet(a11.types);
        Set<Class<?>> bs2 = ConversionCategory.arrayToSet(b11.types);
        as2.retainAll(bs2);
        for (ConversionCategory v11 : new ConversionCategory[]{CHAR, INT, FLOAT, TIME, CHAR_AND_INT, INT_AND_TIME, NULL}) {
            Set<Class<?>> vs2 = ConversionCategory.arrayToSet(v11.types);
            if (!vs2.equals(as2)) continue;
            return v11;
        }
        throw new RuntimeException();
    }

    public static ConversionCategory union(ConversionCategory a11, ConversionCategory b11) {
        if (a11 == UNUSED || b11 == UNUSED) {
            return UNUSED;
        }
        if (a11 == GENERAL || b11 == GENERAL) {
            return GENERAL;
        }
        if (a11 == CHAR_AND_INT && b11 == INT_AND_TIME || a11 == INT_AND_TIME && b11 == CHAR_AND_INT) {
            return INT;
        }
        Set<Class<?>> as2 = ConversionCategory.arrayToSet(a11.types);
        Set<Class<?>> bs2 = ConversionCategory.arrayToSet(b11.types);
        as2.addAll(bs2);
        for (ConversionCategory v11 : new ConversionCategory[]{NULL, CHAR_AND_INT, INT_AND_TIME, CHAR, INT, FLOAT, TIME}) {
            Set<Class<?>> vs2 = ConversionCategory.arrayToSet(v11.types);
            if (!vs2.equals(as2)) continue;
            return v11;
        }
        return GENERAL;
    }

    private String className(Class<?> cls) {
        if (cls == Boolean.class) {
            return "boolean";
        }
        if (cls == Character.class) {
            return "char";
        }
        if (cls == Byte.class) {
            return "byte";
        }
        if (cls == Short.class) {
            return "short";
        }
        if (cls == Integer.class) {
            return "int";
        }
        if (cls == Long.class) {
            return "long";
        }
        if (cls == Float.class) {
            return "float";
        }
        if (cls == Double.class) {
            return "double";
        }
        return cls.getSimpleName();
    }

    @Pure
    public String toString() {
        StringBuilder sb2 = new StringBuilder(this.name());
        sb2.append(" conversion category (one of: ");
        boolean first = true;
        for (Class<?> cls : this.types) {
            if (!first) {
                sb2.append(", ");
            }
            sb2.append(this.className(cls));
            first = false;
        }
        sb2.append(")");
        return sb2.toString();
    }
}

