/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.primitives.ImmutableLongArray;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;

@GwtIncompatible
public class AtomicDoubleArray
implements Serializable {
    private static final long serialVersionUID = 0L;
    private transient AtomicLongArray longs;

    public AtomicDoubleArray(int length) {
        this.longs = new AtomicLongArray(length);
    }

    public AtomicDoubleArray(double[] array) {
        int len = array.length;
        long[] longArray = new long[len];
        for (int i11 = 0; i11 < len; ++i11) {
            longArray[i11] = Double.doubleToRawLongBits(array[i11]);
        }
        this.longs = new AtomicLongArray(longArray);
    }

    public final int length() {
        return this.longs.length();
    }

    public final double get(int i11) {
        return Double.longBitsToDouble(this.longs.get(i11));
    }

    public final void set(int i11, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        this.longs.set(i11, next);
    }

    public final void lazySet(int i11, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        this.longs.lazySet(i11, next);
    }

    public final double getAndSet(int i11, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        return Double.longBitsToDouble(this.longs.getAndSet(i11, next));
    }

    public final boolean compareAndSet(int i11, double expect, double update) {
        return this.longs.compareAndSet(i11, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    public final boolean weakCompareAndSet(int i11, double expect, double update) {
        return this.longs.weakCompareAndSet(i11, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    @CanIgnoreReturnValue
    public final double getAndAdd(int i11, double delta) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        while (!this.longs.compareAndSet(i11, current = this.longs.get(i11), next = Double.doubleToRawLongBits(nextVal = (currentVal = Double.longBitsToDouble(current)) + delta))) {
        }
        return currentVal;
    }

    @CanIgnoreReturnValue
    public double addAndGet(int i11, double delta) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        while (!this.longs.compareAndSet(i11, current = this.longs.get(i11), next = Double.doubleToRawLongBits(nextVal = (currentVal = Double.longBitsToDouble(current)) + delta))) {
        }
        return nextVal;
    }

    public String toString() {
        int iMax = this.length() - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b11 = new StringBuilder(19 * (iMax + 1));
        b11.append('[');
        int i11 = 0;
        while (true) {
            b11.append(Double.longBitsToDouble(this.longs.get(i11)));
            if (i11 == iMax) {
                return b11.append(']').toString();
            }
            b11.append(',').append(' ');
            ++i11;
        }
    }

    private void writeObject(ObjectOutputStream s11) throws IOException {
        s11.defaultWriteObject();
        int length = this.length();
        s11.writeInt(length);
        for (int i11 = 0; i11 < length; ++i11) {
            s11.writeDouble(this.get(i11));
        }
    }

    private void readObject(ObjectInputStream s11) throws IOException, ClassNotFoundException {
        s11.defaultReadObject();
        int length = s11.readInt();
        ImmutableLongArray.Builder builder = ImmutableLongArray.builder();
        for (int i11 = 0; i11 < length; ++i11) {
            builder.add(Double.doubleToRawLongBits(s11.readDouble()));
        }
        this.longs = new AtomicLongArray(builder.build().toArray());
    }
}

