/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLongs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Comparator;
import sun.misc.Unsafe;

@GwtIncompatible
public final class UnsignedBytes {
    public static final byte MAX_POWER_OF_TWO = -128;
    public static final byte MAX_VALUE = -1;
    private static final int UNSIGNED_MASK = 255;

    private UnsignedBytes() {
    }

    public static int toInt(byte value) {
        return value & 0xFF;
    }

    @CanIgnoreReturnValue
    public static byte checkedCast(long value) {
        Preconditions.checkArgument(value >> 8 == 0L, "out of range: %s", value);
        return (byte)value;
    }

    public static byte saturatedCast(long value) {
        if (value > (long)UnsignedBytes.toInt((byte)-1)) {
            return -1;
        }
        if (value < 0L) {
            return 0;
        }
        return (byte)value;
    }

    public static int compare(byte a11, byte b11) {
        return UnsignedBytes.toInt(a11) - UnsignedBytes.toInt(b11);
    }

    public static byte min(byte ... array) {
        Preconditions.checkArgument(array.length > 0);
        int min2 = UnsignedBytes.toInt(array[0]);
        for (int i11 = 1; i11 < array.length; ++i11) {
            int next = UnsignedBytes.toInt(array[i11]);
            if (next >= min2) continue;
            min2 = next;
        }
        return (byte)min2;
    }

    public static byte max(byte ... array) {
        Preconditions.checkArgument(array.length > 0);
        int max = UnsignedBytes.toInt(array[0]);
        for (int i11 = 1; i11 < array.length; ++i11) {
            int next = UnsignedBytes.toInt(array[i11]);
            if (next <= max) continue;
            max = next;
        }
        return (byte)max;
    }

    @Beta
    public static String toString(byte x11) {
        return UnsignedBytes.toString(x11, 10);
    }

    @Beta
    public static String toString(byte x11, int radix) {
        Preconditions.checkArgument(radix >= 2 && radix <= 36, "radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", radix);
        return Integer.toString(UnsignedBytes.toInt(x11), radix);
    }

    @Beta
    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string) {
        return UnsignedBytes.parseUnsignedByte(string, 10);
    }

    @Beta
    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string, int radix) {
        int parse = Integer.parseInt(Preconditions.checkNotNull(string), radix);
        if (parse >> 8 == 0) {
            return (byte)parse;
        }
        throw new NumberFormatException(new StringBuilder(25).append("out of range: ").append(parse).toString());
    }

    public static String join(String separator, byte ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * (3 + separator.length()));
        builder.append(UnsignedBytes.toInt(array[0]));
        for (int i11 = 1; i11 < array.length; ++i11) {
            builder.append(separator).append(UnsignedBytes.toString(array[i11]));
        }
        return builder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparatorHolder.BEST_COMPARATOR;
    }

    @VisibleForTesting
    static Comparator<byte[]> lexicographicalComparatorJavaImpl() {
        return LexicographicalComparatorHolder.PureJavaComparator.INSTANCE;
    }

    private static byte flip(byte b11) {
        return (byte)(b11 ^ 0x80);
    }

    public static void sort(byte[] array) {
        Preconditions.checkNotNull(array);
        UnsignedBytes.sort(array, 0, array.length);
    }

    public static void sort(byte[] array, int fromIndex, int toIndex) {
        int i11;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (i11 = fromIndex; i11 < toIndex; ++i11) {
            array[i11] = UnsignedBytes.flip(array[i11]);
        }
        Arrays.sort(array, fromIndex, toIndex);
        for (i11 = fromIndex; i11 < toIndex; ++i11) {
            array[i11] = UnsignedBytes.flip(array[i11]);
        }
    }

    public static void sortDescending(byte[] array) {
        Preconditions.checkNotNull(array);
        UnsignedBytes.sortDescending(array, 0, array.length);
    }

    public static void sortDescending(byte[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        int i11 = fromIndex;
        while (i11 < toIndex) {
            int n11 = i11++;
            array[n11] = (byte)(array[n11] ^ 0x7F);
        }
        Arrays.sort(array, fromIndex, toIndex);
        i11 = fromIndex;
        while (i11 < toIndex) {
            int n12 = i11++;
            array[n12] = (byte)(array[n12] ^ 0x7F);
        }
    }

    @VisibleForTesting
    static class LexicographicalComparatorHolder {
        static final String UNSAFE_COMPARATOR_NAME = String.valueOf(LexicographicalComparatorHolder.class.getName()).concat("$UnsafeComparator");
        static final Comparator<byte[]> BEST_COMPARATOR = LexicographicalComparatorHolder.getBestComparator();

        LexicographicalComparatorHolder() {
        }

        static Comparator<byte[]> getBestComparator() {
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARATOR_NAME);
                Comparator comparator = (Comparator)theClass.getEnumConstants()[0];
                return comparator;
            }
            catch (Throwable t11) {
                return UnsignedBytes.lexicographicalComparatorJavaImpl();
            }
        }

        static enum PureJavaComparator implements Comparator<byte[]>
        {
            INSTANCE;


            @Override
            public int compare(byte[] left, byte[] right) {
                int minLength = Math.min(left.length, right.length);
                for (int i11 = 0; i11 < minLength; ++i11) {
                    int result = UnsignedBytes.compare(left[i11], right[i11]);
                    if (result == 0) continue;
                    return result;
                }
                return left.length - right.length;
            }

            public String toString() {
                return "UnsignedBytes.lexicographicalComparator() (pure Java version)";
            }
        }

        @VisibleForTesting
        static enum UnsafeComparator implements Comparator<byte[]>
        {
            INSTANCE;

            static final boolean BIG_ENDIAN;
            static final Unsafe theUnsafe;
            static final int BYTE_ARRAY_BASE_OFFSET;

            private static Unsafe getUnsafe() {
                try {
                    return Unsafe.getUnsafe();
                }
                catch (SecurityException securityException) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                            @Override
                            public Unsafe run() throws Exception {
                                Class<Unsafe> k11 = Unsafe.class;
                                for (Field f11 : k11.getDeclaredFields()) {
                                    f11.setAccessible(true);
                                    Object x11 = f11.get(null);
                                    if (!k11.isInstance(x11)) continue;
                                    return (Unsafe)k11.cast(x11);
                                }
                                throw new NoSuchFieldError("the Unsafe");
                            }
                        });
                    }
                    catch (PrivilegedActionException e11) {
                        throw new RuntimeException("Could not initialize intrinsics", e11.getCause());
                    }
                }
            }

            @Override
            public int compare(byte[] left, byte[] right) {
                int i11;
                int stride = 8;
                int minLength = Math.min(left.length, right.length);
                int strideLimit = minLength & 0xFFFFFFF8;
                for (i11 = 0; i11 < strideLimit; i11 += 8) {
                    long rw2;
                    long lw2 = theUnsafe.getLong(left, (long)BYTE_ARRAY_BASE_OFFSET + (long)i11);
                    if (lw2 == (rw2 = theUnsafe.getLong(right, (long)BYTE_ARRAY_BASE_OFFSET + (long)i11))) continue;
                    if (BIG_ENDIAN) {
                        return UnsignedLongs.compare(lw2, rw2);
                    }
                    int n11 = Long.numberOfTrailingZeros(lw2 ^ rw2) & 0xFFFFFFF8;
                    return (int)(lw2 >>> n11 & 0xFFL) - (int)(rw2 >>> n11 & 0xFFL);
                }
                while (i11 < minLength) {
                    int result = UnsignedBytes.compare(left[i11], right[i11]);
                    if (result != 0) {
                        return result;
                    }
                    ++i11;
                }
                return left.length - right.length;
            }

            public String toString() {
                return "UnsignedBytes.lexicographicalComparator() (sun.misc.Unsafe version)";
            }

            static {
                BIG_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
                theUnsafe = UnsafeComparator.getUnsafe();
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                if (!"64".equals(System.getProperty("sun.arch.data.model")) || BYTE_ARRAY_BASE_OFFSET % 8 != 0 || theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new Error();
                }
            }
        }
    }
}

