/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.ArrayBasedEscaperMap;
import com.google.common.escape.UnicodeEscaper;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
@GwtCompatible
public abstract class ArrayBasedUnicodeEscaper
extends UnicodeEscaper {
    private final char[][] replacements;
    private final int replacementsLength;
    private final int safeMin;
    private final int safeMax;
    private final char safeMinChar;
    private final char safeMaxChar;

    protected ArrayBasedUnicodeEscaper(Map<Character, String> replacementMap, int safeMin, int safeMax, @Nullable String unsafeReplacement) {
        this(ArrayBasedEscaperMap.create(replacementMap), safeMin, safeMax, unsafeReplacement);
    }

    protected ArrayBasedUnicodeEscaper(ArrayBasedEscaperMap escaperMap, int safeMin, int safeMax, @Nullable String unsafeReplacement) {
        Preconditions.checkNotNull(escaperMap);
        this.replacements = escaperMap.getReplacementArray();
        this.replacementsLength = this.replacements.length;
        if (safeMax < safeMin) {
            safeMax = -1;
            safeMin = Integer.MAX_VALUE;
        }
        this.safeMin = safeMin;
        this.safeMax = safeMax;
        if (safeMin >= 55296) {
            this.safeMinChar = (char)65535;
            this.safeMaxChar = '\u0000';
        } else {
            this.safeMinChar = (char)safeMin;
            this.safeMaxChar = (char)Math.min(safeMax, 55295);
        }
    }

    @Override
    public final String escape(String s11) {
        Preconditions.checkNotNull(s11);
        for (int i11 = 0; i11 < s11.length(); ++i11) {
            char c11 = s11.charAt(i11);
            if ((c11 >= this.replacementsLength || this.replacements[c11] == null) && c11 <= this.safeMaxChar && c11 >= this.safeMinChar) continue;
            return this.escapeSlow(s11, i11);
        }
        return s11;
    }

    @Override
    protected final char[] escape(int cp2) {
        char[] chars;
        if (cp2 < this.replacementsLength && (chars = this.replacements[cp2]) != null) {
            return chars;
        }
        if (cp2 >= this.safeMin && cp2 <= this.safeMax) {
            return null;
        }
        return this.escapeUnsafe(cp2);
    }

    @Override
    protected final int nextEscapeIndex(CharSequence csq, int index, int end) {
        char c11;
        while (index < end && ((c11 = csq.charAt(index)) >= this.replacementsLength || this.replacements[c11] == null) && c11 <= this.safeMaxChar && c11 >= this.safeMinChar) {
            ++index;
        }
        return index;
    }

    protected abstract char[] escapeUnsafe(int var1);
}

