/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.LexicographicalOrdering;
import com.google.common.collect.TopKSelector;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public final class Comparators {
    private Comparators() {
    }

    @Beta
    public static <T, S extends T> Comparator<Iterable<S>> lexicographical(Comparator<T> comparator) {
        return new LexicographicalOrdering<T>(Preconditions.checkNotNull(comparator));
    }

    @Beta
    public static <T> boolean isInOrder(Iterable<? extends T> iterable, Comparator<T> comparator) {
        Preconditions.checkNotNull(comparator);
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next = it.next();
                if (comparator.compare(prev, next) > 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    @Beta
    public static <T> boolean isInStrictOrder(Iterable<? extends T> iterable, Comparator<T> comparator) {
        Preconditions.checkNotNull(comparator);
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next = it.next();
                if (comparator.compare(prev, next) >= 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    public static <T> Collector<T, ?, List<T>> least(int k11, Comparator<? super T> comparator) {
        CollectPreconditions.checkNonnegative(k11, "k");
        Preconditions.checkNotNull(comparator);
        return Collector.of(() -> TopKSelector.least(k11, comparator), TopKSelector::offer, TopKSelector::combine, TopKSelector::topK, Collector.Characteristics.UNORDERED);
    }

    public static <T> Collector<T, ?, List<T>> greatest(int k11, Comparator<? super T> comparator) {
        return Comparators.least(k11, comparator.reversed());
    }

    @Beta
    public static <T> Comparator<Optional<T>> emptiesFirst(Comparator<? super T> valueComparator) {
        Preconditions.checkNotNull(valueComparator);
        return Comparator.comparing(o11 -> o11.orElse(null), Comparator.nullsFirst(valueComparator));
    }

    @Beta
    public static <T> Comparator<Optional<T>> emptiesLast(Comparator<? super T> valueComparator) {
        Preconditions.checkNotNull(valueComparator);
        return Comparator.comparing(o11 -> o11.orElse(null), Comparator.nullsLast(valueComparator));
    }

    @Beta
    public static <T extends Comparable<? super T>> T min(T a11, T b11) {
        return a11.compareTo(b11) <= 0 ? a11 : b11;
    }

    @Beta
    public static <T> T min(@Nullable T a11, @Nullable T b11, Comparator<T> comparator) {
        return comparator.compare(a11, b11) <= 0 ? a11 : b11;
    }

    @Beta
    public static <T extends Comparable<? super T>> T max(T a11, T b11) {
        return a11.compareTo(b11) >= 0 ? a11 : b11;
    }

    @Beta
    public static <T> T max(@Nullable T a11, @Nullable T b11, Comparator<T> comparator) {
        return comparator.compare(a11, b11) >= 0 ? a11 : b11;
    }
}

