/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SourceStamp;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.splitters.ApkGenerationConfiguration;
import com.android.tools.build.bundletool.splitters.ModuleSplitter;
import com.android.tools.build.bundletool.splitters.VariantTargetingGenerator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import javax.inject.Inject;

public final class SplitApksGenerator {
    private final Version bundletoolVersion;
    private final Optional<SourceStamp> stampSource;
    private final VariantTargetingGenerator variantTargetingGenerator;
    private final AppBundle appBundle;

    @Inject
    public SplitApksGenerator(Version bundletoolVersion, Optional<SourceStamp> stampSource, VariantTargetingGenerator variantTargetingGenerator, AppBundle appBundle) {
        this.bundletoolVersion = bundletoolVersion;
        this.stampSource = stampSource;
        this.variantTargetingGenerator = variantTargetingGenerator;
        this.appBundle = appBundle;
    }

    public ImmutableList<ModuleSplit> generateSplits(ImmutableList<BundleModule> modules, ApkGenerationConfiguration apkGenerationConfiguration) {
        return this.variantTargetingGenerator.generateVariantTargetings(modules, apkGenerationConfiguration).stream().flatMap(variantTargeting -> this.generateSplitApks(modules, apkGenerationConfiguration, (Targeting.VariantTargeting)variantTargeting).stream()).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<ModuleSplit> generateSplitApks(ImmutableList<BundleModule> modules, ApkGenerationConfiguration apkGenerationConfiguration, Targeting.VariantTargeting variantTargeting) {
        ImmutableSet<String> allModuleNames = modules.stream().map(module -> module.getName().getName()).collect(ImmutableSet.toImmutableSet());
        ImmutableList.Builder splits = ImmutableList.builder();
        for (BundleModule module2 : modules) {
            ModuleSplitter moduleSplitter = ModuleSplitter.create(module2, this.bundletoolVersion, this.appBundle, apkGenerationConfiguration, variantTargeting, allModuleNames, this.stampSource.map(SourceStamp::getSource), SourceStamp.StampType.STAMP_TYPE_DISTRIBUTION_APK);
            splits.addAll(moduleSplitter.splitModule());
        }
        return splits.build();
    }
}

