/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.manifestelements.Activity;
import com.android.tools.build.bundletool.model.manifestelements.Receiver;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttributeBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElementBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNode;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNodeBuilder;
import com.android.tools.build.bundletool.model.version.Version;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Optional;
import java.util.stream.Collectors;

public class ManifestEditor {
    private static final ImmutableList<String> SPLIT_NAME_ELEMENT_NAMES = ImmutableList.of("activity", "service", "provider");
    private final XmlProtoNodeBuilder rootNode;
    private final XmlProtoElementBuilder manifestElement;
    private final Version bundleToolVersion;

    public ManifestEditor(XmlProtoNode rootNode, Version bundleToolVersion) {
        this.rootNode = rootNode.toBuilder();
        this.manifestElement = (XmlProtoElementBuilder)this.rootNode.getElement();
        this.bundleToolVersion = bundleToolVersion;
    }

    public XmlProtoElementBuilder getRawProto() {
        return this.manifestElement;
    }

    public ManifestEditor setMinSdkVersion(int minSdkVersion) {
        return this.setUsesSdkAttribute("minSdkVersion", 16843276, minSdkVersion);
    }

    public ManifestEditor setMaxSdkVersion(int maxSdkVersion) {
        return this.setUsesSdkAttribute("maxSdkVersion", 16843377, maxSdkVersion);
    }

    public ManifestEditor setTargetSdkVersion(int targetSdkVersion) {
        return this.setUsesSdkAttribute("targetSdkVersion", 16843376, targetSdkVersion);
    }

    public ManifestEditor setSplitIdForFeatureSplit(String splitId) {
        if (ManifestEditor.isBaseSplit(splitId)) {
            this.manifestElement.removeAttribute("", "split");
            this.manifestElement.removeAttribute("http://schemas.android.com/apk/res/android", "isFeatureSplit");
        } else {
            this.manifestElement.getOrCreateAttribute("split").setValueAsString(splitId);
            this.manifestElement.getOrCreateAndroidAttribute("isFeatureSplit", 16844123).setValueAsBoolean(true);
        }
        this.manifestElement.removeAttribute("", "configForSplit");
        return this;
    }

    public ManifestEditor setHasCode(boolean value) {
        return this.setApplcationAttributeBoolean("hasCode", 0x101000C, value);
    }

    public ManifestEditor setPackage(String packageName) {
        this.manifestElement.getOrCreateAttribute("package").setValueAsString(packageName);
        return this;
    }

    public ManifestEditor setVersionCode(int versionCode) {
        this.manifestElement.getOrCreateAndroidAttribute("versionCode", 16843291).setValueAsDecimalInteger(versionCode);
        return this;
    }

    public ManifestEditor setVersionName(String versionName) {
        this.manifestElement.getOrCreateAndroidAttribute("versionName", 16843292).setValueAsString(versionName);
        return this;
    }

    public ManifestEditor setConfigForSplit(String featureSplitId) {
        this.manifestElement.getOrCreateAttribute("configForSplit").setValueAsString(featureSplitId);
        return this;
    }

    public ManifestEditor setSplitId(String splitId) {
        this.manifestElement.getOrCreateAttribute("split").setValueAsString(splitId);
        return this;
    }

    public ManifestEditor setTargetSandboxVersion(int version) {
        this.manifestElement.getOrCreateAndroidAttribute("targetSandboxVersion", 16844108).setValueAsDecimalInteger(version);
        return this;
    }

    public ManifestEditor setSharedUserId(String value) {
        this.manifestElement.getOrCreateAndroidAttribute("sharedUserId", 0x101000B).setValueAsString(value);
        return this;
    }

    public ManifestEditor setSharedUserLabel(Integer valueRefId) {
        this.manifestElement.getOrCreateAndroidAttribute("sharedUserLabel", 16843361).setValueAsRefId(valueRefId);
        return this;
    }

    public ManifestEditor setLocaleConfig(int resourceId) {
        return this.setApplcationAttributeRefId("localeConfig", 31391758, resourceId);
    }

    public ManifestEditor addMetaDataString(String key, String value) {
        return this.addMetaDataValue(key, XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842788).setValueAsString(value));
    }

    public ManifestEditor addMetaDataInteger(String key, int value) {
        return this.addMetaDataValue(key, XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842788).setValueAsDecimalInteger(value));
    }

    public ManifestEditor addMetaDataBoolean(String key, boolean value) {
        return this.addMetaDataValue(key, XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842788).setValueAsBoolean(value));
    }

    public ManifestEditor addMetaDataResourceId(String key, int resourceId) {
        return this.addMetaDataValue(key, XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842789).setValueAsRefId(resourceId));
    }

    private ManifestEditor addMetaDataValue(String key, XmlProtoAttributeBuilder valueAttribute) {
        this.manifestElement.getOrCreateChildElement("application").addChildElement(XmlProtoElementBuilder.create("meta-data").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString(key)).addAttribute(valueAttribute));
        return this;
    }

    public ManifestEditor setExtractNativeLibsValue(boolean value) {
        this.setApplcationAttributeBoolean("extractNativeLibs", 16844010, value);
        return this;
    }

    public ManifestEditor setFusedModuleNames(ImmutableList<String> moduleNames) {
        String moduleNamesString = moduleNames.stream().sorted().distinct().collect(Collectors.joining(","));
        this.setMetadataValue("com.android.dynamic.apk.fused.modules", XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842788).setValueAsString(moduleNamesString));
        return this;
    }

    public ManifestEditor setSplitsRequired(boolean value) {
        this.setMetadataValue("com.android.vending.splits.required", XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842788).setValueAsBoolean(value));
        return this.setApplcationAttributeBoolean("isSplitRequired", 16844177, value);
    }

    public ManifestEditor addApplicationElementIfMissing() {
        this.manifestElement.getOrCreateChildElement("application");
        return this;
    }

    public ManifestEditor setDescription(Integer refIdValue) {
        return this.setApplcationAttributeRefId("description", 0x1010020, refIdValue);
    }

    public ManifestEditor setHasFragileUserData(Boolean value) {
        return this.setApplcationAttributeBoolean("hasFragileUserData", 16844186, value);
    }

    public ManifestEditor setIsGame(Boolean value) {
        return this.setApplcationAttributeBoolean("isGame", 16843764, value);
    }

    public ManifestEditor setLabelAsString(String value) {
        return this.setApplcationAttributeString("label", 0x1010001, value);
    }

    public ManifestEditor setLabelAsRefId(Integer refIdValue) {
        return this.setApplcationAttributeRefId("label", 0x1010001, refIdValue);
    }

    public ManifestEditor setIcon(Integer refIdValue) {
        return this.setApplcationAttributeRefId("icon", 0x1010002, refIdValue);
    }

    public ManifestEditor setBanner(Integer refIdValue) {
        return this.setApplcationAttributeRefId("banner", 16843762, refIdValue);
    }

    public ManifestEditor setAllowBackup(Boolean value) {
        return this.setApplcationAttributeBoolean("allowBackup", 16843392, value);
    }

    public ManifestEditor setFullBackupOnly(Boolean value) {
        return this.setApplcationAttributeBoolean("fullBackupOnly", 16843891, value);
    }

    public ManifestEditor setFullBackupContent(Integer value) {
        return this.setApplcationAttributeRefId("fullBackupContent", 16844011, value);
    }

    public ManifestEditor setDataExtractionRules(Integer value) {
        return this.setApplcationAttributeRefId("dataExtractionRules", 16844350, value);
    }

    public ManifestEditor setRestrictedAccountType(String value) {
        return this.setApplcationAttributeString("restrictedAccountType", 16843733, value);
    }

    public ManifestEditor setRequiredAccountType(String value) {
        return this.setApplcationAttributeString("requiredAccountType", 16843734, value);
    }

    public ManifestEditor setLargeHeap(Boolean value) {
        return this.setApplcationAttributeBoolean("largeHeap", 16843610, value);
    }

    private ManifestEditor setApplcationAttributeString(String attributeName, int resourceId, String value) {
        this.manifestElement.getOrCreateChildElement("application").getOrCreateAndroidAttribute(attributeName, resourceId).setValueAsString(value);
        return this;
    }

    private ManifestEditor setApplcationAttributeBoolean(String attributeName, int resourceId, boolean value) {
        this.manifestElement.getOrCreateChildElement("application").getOrCreateAndroidAttribute(attributeName, resourceId).setValueAsBoolean(value);
        return this;
    }

    private ManifestEditor setApplcationAttributeRefId(String attributeName, int resourceId, int value) {
        this.manifestElement.getOrCreateChildElement("application").getOrCreateAndroidAttribute(attributeName, resourceId).setValueAsRefId(value);
        return this;
    }

    public ManifestEditor removeSplitName() {
        this.manifestElement.getOrCreateChildElement("application").getChildrenElements(el2 -> SPLIT_NAME_ELEMENT_NAMES.contains(el2.getName())).forEach(element -> element.removeAndroidAttribute(16844105));
        return this;
    }

    public ManifestEditor removeUnknownSplitComponents(ImmutableSet<String> allModuleNames) {
        Optional applicationElement = this.manifestElement.getOptionalChildElement("application");
        if (!applicationElement.isPresent()) {
            return this;
        }
        ((XmlProtoElementBuilder)applicationElement.get()).removeChildrenElementsIf(el2 -> el2.isElement() && ((XmlProtoElementBuilder)el2.getElement()).getAndroidAttribute(16844105).filter(attr -> !allModuleNames.contains(attr.getValueAsString())).isPresent());
        return this;
    }

    public ManifestEditor addActivity(Activity activity) {
        this.manifestElement.getOrCreateChildElement("application").addChildElement(activity.asXmlProtoElement().toBuilder());
        return this;
    }

    public ManifestEditor addReceiver(Receiver receiver) {
        this.manifestElement.getOrCreateChildElement("application").addChildElement(receiver.asXmlProtoElement().toBuilder());
        return this;
    }

    public ManifestEditor copyPermissions(AndroidManifest manifest) {
        manifest.getPermissions().forEach(permission -> this.manifestElement.addChildElement(permission.toBuilder()));
        return this;
    }

    public ManifestEditor copyPermissionGroups(AndroidManifest manifest) {
        manifest.getPermissionGroups().forEach(permissionGroup -> this.manifestElement.addChildElement(permissionGroup.toBuilder()));
        return this;
    }

    public ManifestEditor copyPermissionTrees(AndroidManifest manifest) {
        manifest.getPermissionTrees().forEach(permissionTree -> this.manifestElement.addChildElement(permissionTree.toBuilder()));
        return this;
    }

    public ManifestEditor addUsesSdkLibraryElement(String name, long versionMajor, String certDigest) {
        this.manifestElement.getOrCreateChildElement("application").addChildElement(XmlProtoElementBuilder.create("uses-sdk-library").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString(name)).addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("versionMajor", 16844151).setValueAsString(String.valueOf(versionMajor))).addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("certDigest", 16844104).setValueAsString(certDigest)));
        return this;
    }

    public ManifestEditor setSdkLibraryElement(String sdkPackageName, int versionMajor) {
        this.manifestElement.getOrCreateChildElement("application").getOrCreateChildElement("sdk-library").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString(sdkPackageName)).addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("versionMajor", 16844151).setValueAsDecimalInteger(versionMajor));
        return this;
    }

    public ManifestEditor setSdkPatchVersionProperty(int patchVersion) {
        this.manifestElement.getOrCreateChildElement("application").addChildElement(XmlProtoElementBuilder.create("property").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString("com.android.vending.sdk.version.patch")).addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842788).setValueAsDecimalInteger(patchVersion)));
        return this;
    }

    @CheckReturnValue
    public AndroidManifest save() {
        return AndroidManifest.create(this.rootNode.build(), this.bundleToolVersion);
    }

    private ManifestEditor setMetadataValue(String name, XmlProtoAttributeBuilder valueAttr) {
        XmlProtoElementBuilder applicationEl = this.manifestElement.getOrCreateChildElement("application");
        Optional existingMetadataEl = applicationEl.getChildrenElements("meta-data").filter(metadataEl -> metadataEl.getAndroidAttribute(0x1010003).map(nameAttr -> name.equals(nameAttr.getValueAsString())).orElse(false)).collect(MoreCollectors.toOptional());
        if (existingMetadataEl.isPresent()) {
            ((XmlProtoElementBuilder)existingMetadataEl.get()).removeAndroidAttribute(16842788).addAttribute(valueAttr);
        } else {
            applicationEl.addChildElement(XmlProtoElementBuilder.create("meta-data").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString(name)).addAttribute(valueAttr));
        }
        return this;
    }

    private ManifestEditor setUsesSdkAttribute(String attributeName, int attributeResId, int value) {
        this.manifestElement.getOrCreateChildElement("uses-sdk").getOrCreateAndroidAttribute(attributeName, attributeResId).setValueAsDecimalInteger(value);
        return this;
    }

    private static boolean isBaseSplit(String splitId) {
        return splitId.isEmpty();
    }
}

