/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.io.ModuleEntriesPack;
import com.android.tools.build.bundletool.io.Zipper;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.zipflinger.ZipMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.IdentityHashMap;
import java.util.Map;

class ModuleEntriesPacker {
    private final String namePrefix;
    private final Path outputZip;
    private final IdentityHashMap<ModuleEntry, String> entryNameByModuleEntry;
    private final Map<String, ByteSource> contentByEntryName;
    private final Map<ModuleEntry.ModuleEntryBundleLocation, String> assignedEntryNameByBundleLocation;
    private final NameAssigner nameAssigner;

    public ModuleEntriesPacker(Path outputZip, String namePrefix) {
        this.namePrefix = namePrefix;
        this.outputZip = outputZip;
        this.nameAssigner = new NameAssigner(namePrefix);
        this.entryNameByModuleEntry = Maps.newIdentityHashMap();
        this.contentByEntryName = Maps.newHashMap();
        this.assignedEntryNameByBundleLocation = Maps.newHashMap();
    }

    ModuleEntriesPacker add(ModuleEntry entry) {
        if (this.entryNameByModuleEntry.containsKey(entry)) {
            return this;
        }
        String entryName = entry.getBundleLocation().isPresent() ? this.assignedByBundleLocation(entry) : this.nameAssigner.nextName();
        this.entryNameByModuleEntry.put(entry, entryName);
        this.contentByEntryName.putIfAbsent(entryName, entry.getContent());
        return this;
    }

    public ModuleEntriesPack pack(Zipper zipper) {
        try {
            zipper.zip(this.outputZip, ImmutableMap.copyOf(this.contentByEntryName));
            IdentityHashMap<ModuleEntry, String> copyOfEntryNameByModuleEntry = Maps.newIdentityHashMap();
            copyOfEntryNameByModuleEntry.putAll(this.entryNameByModuleEntry);
            return new ModuleEntriesPack(ImmutableSet.of(this.namePrefix), ZipMap.from(this.outputZip), copyOfEntryNameByModuleEntry);
        }
        catch (IOException e11) {
            throw new UncheckedIOException(e11);
        }
    }

    private String assignedByBundleLocation(ModuleEntry entry) {
        return this.assignedEntryNameByBundleLocation.computeIfAbsent(entry.getBundleLocation().get(), location -> this.nameAssigner.nextName());
    }

    private static class NameAssigner {
        private final String prefix;
        private int counter = 0;

        NameAssigner(String prefix) {
            this.prefix = prefix;
        }

        String nextName() {
            return this.prefix + String.valueOf(this.counter++);
        }
    }
}

