/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Config;
import com.android.bundle.Devices;
import com.android.bundle.SdkModulesConfigOuterClass;
import com.android.tools.build.bundletool.androidtools.Aapt2Command;
import com.android.tools.build.bundletool.androidtools.P7ZipCommand;
import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.tools.build.bundletool.commands.BuildApksModule;
import com.android.tools.build.bundletool.commands.BuildSdkApksCommand;
import com.android.tools.build.bundletool.commands.CommandUtils;
import com.android.tools.build.bundletool.io.ApkSerializer;
import com.android.tools.build.bundletool.io.ModuleSplitSerializer;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.ApkListener;
import com.android.tools.build.bundletool.model.ApkModifier;
import com.android.tools.build.bundletool.model.Bundle;
import com.android.tools.build.bundletool.model.DefaultSigningConfigurationProvider;
import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.SigningConfigurationProvider;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import com.google.common.util.concurrent.ListeningExecutorService;
import dagger.Binds;
import dagger.BindsOptionalOf;
import dagger.Module;
import dagger.Provides;
import java.util.Optional;

@Module
public abstract class BuildSdkApksModule {
    @Provides
    static Aapt2Command provideAapt2Command(BuildSdkApksCommand command, TempDirectory tempDir) {
        return command.getAapt2Command().orElseGet(() -> CommandUtils.extractAapt2FromJar(tempDir.getPath()));
    }

    @Provides
    static Version provideBundletoolVersion(SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig) {
        return Version.of(sdkModulesConfig.getBundletool().getVersion());
    }

    @Provides
    static SdkModulesConfigOuterClass.SdkModulesConfig provideSdkModulesConfig(SdkBundle sdkBundle) {
        return sdkBundle.getSdkModulesConfig();
    }

    @Provides
    static Config.BundleConfig provideBundleConfig(SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig) {
        return Config.BundleConfig.newBuilder().setBundletool(sdkModulesConfig.getBundletool()).build();
    }

    @Binds
    abstract Bundle bundle(SdkBundle var1);

    @BindsOptionalOf
    @BuildApksModule.StampSigningConfig
    abstract SigningConfiguration bindOptionalSigningConfiguration();

    @Provides
    @BuildApksModule.ApkSigningConfigProvider
    static Optional<SigningConfigurationProvider> provideApkSigningConfigurationProvider(BuildSdkApksCommand command, Version version) {
        return command.getSigningConfiguration().map(signingConfig -> new DefaultSigningConfigurationProvider((SigningConfiguration)signingConfig, version));
    }

    @BindsOptionalOf
    abstract Devices.DeviceSpec bindOptionalDeviceSpec();

    @Provides
    static ListeningExecutorService provideExecutorService(BuildSdkApksCommand command) {
        return command.getExecutorService();
    }

    @BindsOptionalOf
    abstract ApkListener bindOptionalApkListener();

    @BindsOptionalOf
    abstract ApkModifier bindOptionalApkModifier();

    @BindsOptionalOf
    abstract P7ZipCommand bindOptionalP7ZipCommand();

    @Provides
    static ApkOptimizations provideApkOptimizations() {
        return ApkOptimizations.getOptimizationsForUniversalApk();
    }

    @Provides
    static BuildApksCommand.ApkBuildMode provideApkBuildMode() {
        return BuildApksCommand.ApkBuildMode.DEFAULT;
    }

    @BuildApksModule.FirstVariantNumber
    @Provides
    static Optional<Integer> provideFirstVariantNumber() {
        return Optional.of(0);
    }

    @Provides
    @BuildApksModule.VerboseLogs
    static boolean provideVerbose(BuildSdkApksCommand command) {
        return command.getVerbose();
    }

    @Binds
    abstract ApkSerializer apkSerializerHelper(ModuleSplitSerializer var1);
}

