/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.androidtools;

import com.android.tools.build.bundletool.androidtools.CommandExecutor;
import com.android.tools.build.bundletool.androidtools.DefaultCommandExecutor;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.time.Duration;

public interface Aapt2Command {
    public void convertApkProtoToBinary(Path var1, Path var2);

    public void optimizeToSparseResourceTables(Path var1, Path var2);

    default public ImmutableList<String> dumpBadging(Path apkPath) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static Aapt2Command createFromExecutablePath(final Path aapt2Path) {
        return new Aapt2Command(){
            private final Duration timeoutMillis = Duration.ofMinutes(5L);

            @Override
            public void convertApkProtoToBinary(Path protoApk, Path binaryApk) {
                ImmutableList<String> convertCommand = ImmutableList.of(aapt2Path.toString(), "convert", "--output-format", "binary", "-o", binaryApk.toString(), protoApk.toString());
                new DefaultCommandExecutor().execute(convertCommand, CommandExecutor.CommandOptions.builder().setTimeout(this.timeoutMillis).build());
            }

            @Override
            public void optimizeToSparseResourceTables(Path originalApk, Path outputApk) {
                ImmutableList<String> convertCommand = ImmutableList.of(aapt2Path.toString(), "optimize", "--enable-sparse-encoding", "-o", outputApk.toString(), originalApk.toString());
                new DefaultCommandExecutor().execute(convertCommand, CommandExecutor.CommandOptions.builder().setTimeout(this.timeoutMillis).build());
            }

            @Override
            public ImmutableList<String> dumpBadging(Path apkPath) {
                return new DefaultCommandExecutor().executeAndCapture(ImmutableList.of(aapt2Path.toString(), "dump", "badging", apkPath.toString()), CommandExecutor.CommandOptions.builder().setTimeout(this.timeoutMillis).build());
            }
        };
    }
}

